	% Example 9.9 LP Cauer
	clear all
	fs = 16; 		% Font size
	lw = 2; 		% Linewidth
	fn = 'times'; 	% Font
	% Requirements for the digital lowpass filter
	wcT = 0.4*pi;
	wsT = 0.5*pi;
	Amax = 0.1;
	Amin = 60;
	
	% Requirements for the analog prototype lowpass filter
	T = 1;
	Wac = (2/T)*tan(wcT/2);
	Was = (2/T)*tan(wsT/2);
	
	% Design of the analog prototype lowpass filter (Cauer)
	N = CA_ORDER_S(Wac, Was, Amax, Amin)
	N = 7;	% We must select an integer order	
	[Ga, Za, R_ZEROS, Pa, Wsnew] = CA_POLES_S(Wac, Was, Amax, Amin, N)
	
	% Transformation of the analog prototype filter into the digital filter
	[G, Z, P] = PZ_2_PZ_Z(Ga, Za, Pa, T)
	figure(1)
	PLOT_PZ_Z(Z, P)
	
	% Computation of attenuation and group delay
	wT = linspace(0, pi, 1000);
	Att = PZ_2_ATT_Z(G, Z, P, wT);
	Taug = PZ_2_TG_Z(G, Z, P, wT);
	figure(2)
	axis_Amax = 80;
	axis_Tg_max = 40;
	PLOT_ATT_TG_Z(Att, Taug, wT, axis_Amax, axis_Tg_max)
		fs = 16; % Font size
	lw = 1; % Linewidth
	fn = 'times'; % Font
	text(0.5, 11.5,'{\it\tau_g}({\ite^j^\omega^T })','FontName',fn,'FontSize',fs);	
	text(1.5, 20,'{\itA}({\ite^j^\omega^T})','FontName',fn,'FontSize',fs);
	
	
	
	OmegaT = 0.4*pi; wcT = 0.75*pi;
	[Ghp, Zhp, Php] = PZ_2_HP_Z(G, Z, P, OmegaT, wcT)
	figure(3)
	PLOT_PZ_Z(Zhp, Php)
	figure(4)
	subplot(2,1,1)
	Att = PZ_2_ATT_Z(Ghp, Zhp, Php, wT);
	Taug = PZ_2_TG_Z(Ghp, Zhp, Php, wT);
	PLOT_ATT_TG_Z(Att, Taug, wT, axis_Amax, axis_Tg_max)
		
% Standard settings
	fs = 16; % Font size
	lw = 1; % Linewidth
	fn = 'times'; % Font
	text(0.5, 9.5,'{\it\tau_g}({\ite^j^\omega^T })','FontName',fn,'FontSize',fs);	
	text(1.8, 20,'{\itA}({\ite^j^\omega^T})','FontName',fn,'FontSize',fs);
